const { firefox } = require('playwright');

(async () => {
    options = {
        // Path to unzipped files
        executablePath: "foxhound/foxhound",
    };

    console.log("Starting browser");
    const browser = await firefox.launch(options);
    console.log("Browser Version:", browser.version(), "connected:", browser.isConnected());
    const context = await browser.newContext();

    // Add hooks to extract taint information
    context.addInitScript(
        { content: "window.addEventListener('__taintreport', (r) => { __playwright_taint_report(r.detail, r.detail.str.taint); });"}
    );
    context.exposeBinding("__playwright_taint_report", async function (source, value, taint) {
        console.log(value);
        console.log(JSON.stringify(taint, null, 2));
    });

    console.log("Loading new page");
    const page = await context.newPage();

    console.log("Navigating");
    await page.goto("https://domgo.at/cxss/example/1?payload=abcd&sp=x#12345");

    await browser.close();
})();
